implementation module ioState;

import StdClass;
import	StdInt, StdBool, StdMisc, StdString;
import	events, menus, windows, controls, pointer, desk;
import	timerDef, menuDef, windowDef, dialogDef, event;
from	deltaIOSystem	import	::DeviceSystem, TimerSystem, MenuSystem,
								WindowSystem, DialogSystem,
								AppleEventSystem,::AppleEventSystemState,::AppleEventHandler;
from	deltaPicture	import	::Point;

EmptyMacMenuHandle :== 0;

::	*IOState *s
	=	{	iodevices	:: ![DeviceSystemState s]
		,	ioevents	:: !EVENTS
		,	iobutton	:: !ButtonFreqState
		,	iotoolbox	:: !*Toolbox
		,	ioworld		:: *[*World]
		};

::	DeviceSystemState	*s	=	TimerSystemState	(TimerHandles	s)
							|	MenuSystemState		(MenuHandles	s)
							|	WindowSystemState	(WindowHandles	s)
							|	DialogSystemState	(DialogHandles	s)
							|	AppleEventSystemState (AppleEventSystemState s (IOState s));

::	TimerHandles		*s	:==	[TimerHandle s];
::	TimerHandle			*s	:==	(!TimerDef s (IOState s), !Time);
::	Time					:==	Int;
						

::	MenuHandles			*s	:==	(![MenuHandle s], ![Char], !MacMenuHandle, !Bool);
::	MenuHandle			*s
	= 	PullDownHandle		MacMenuHandle MenuId MenuId SelectState [MenuHandle s]
	| 	MenuItemHandle		MenuItemId Char (MenuFunction s (IOState s))
	| 	CheckMenuItemHandle	MenuItemId Char (MenuFunction s (IOState s))
	| 	SubMenuItemHandle	MacMenuHandle MenuId MenuId	[MenuHandle s]
	| 	MenuItemGroupHandle	MenuItemGroupId				[MenuHandle s]
	| 	MenuRadioItemsHandle							[MenuHandle s]
	| 	MenuSeparatorHandle;


::	WindowHandles		*s	:==	(![WindowHandle s], !GlobalCursor);
::	WindowHandle		*s	:==	(!WindowDef s (IOState s), !Window);
::	Window
	:==	(	!WindowPtr,
			!ScrollState,
			!ScrollState,
			!Int,
			!UpdateArea,
			!ZoomState	);
::	ScrollState
	:==	(	!ControlHandle,
			!Int,
			!Int		);
::	ZoomState
	:==	(	!Int,
			!Int		);
::	GlobalCursor
	=	GlobalCursorSet CursorShape
	|	NoGlobalCursor;
::	DoubleDownDist
	:==	Int;

::	DialogHandles		*s	:==	[DialogRep s (IOState s)];

::	Device = TimerDevice | MenuDevice | WindowDevice | DialogDevice | AppleEventDevice;

::	DeviceFunctions		*s
	:==	(	!ShowFunction	s,
			!OpenFunction	s,
			!DoIOFunction	s,
			!CloseFunction	s,
			!HideFunction	s	);

::	ShowFunction  *s :== (IOState s) -> IOState s;
::	OpenFunction  *s :== (DeviceSystem s (IOState s)) -> ((IOState s) -> IOState s);
::	DoIOFunction  *s :== Event -> (s -> *((IOState s) -> *(!Bool, !s, !IOState s)));
::	CloseFunction *s :== (IOState s) -> IOState s;
::	HideFunction  *s :== (IOState s) -> IOState s;


::	ButtonFreqState	:== (!Time, !ButtonFreq, !DoubleDownDist, !Point, !WindowPtr);
::	ButtonFreq		:== Int;


DoubleTime	:== 752;	// the address containing the LongInt of the DoubleTime.


IOStateError :: String String -> .x;
IOStateError f error = Error f "ioState" error;


//	Creation rules for IOStates:

NewIOStateFromOld :: !(IOState s) -> (!IOState t, !IOState s);
//NewIOStateFromOld (ds, es, bfs, tb) = (EmptyIOState es, (ds, EmptyEVENTS, bfs, tb));
NewIOStateFromOld io=:{ioevents} = (EmptyIOState ioevents,{io & ioevents=EmptyEVENTS});

OldIOStateFromNew :: !(IOState s) !(IOState t) -> IOState s;
//OldIOStateFromNew (ds, e, bfs, tb) (_, es, _, _) 
//	| IsEmptyEVENTS e = (ds, es, bfs, tb);
OldIOStateFromNew old=:{ioevents=oldEvents} new=:{ioevents=newEvents}
	| IsEmptyEVENTS oldEvents = {old & ioevents=newEvents};

EmptyIOState :: !EVENTS -> IOState s;
//EmptyIOState es = ([], es, InitButtonFreqState, NewToolbox);
EmptyIOState es = {iodevices=[],ioevents=es,iobutton=InitButtonFreqState,iotoolbox=NewToolbox,ioworld=[]};

IOStateEvents :: !(IOState s) -> EVENTS;
//IOStateEvents (ds, es, bfs, tb) = es;
IOStateEvents {ioevents} = ioevents;


	InitButtonFreqState	:==	(0, 0, 5, (0,0), 0);
//	InitButtonFreqState	=	(time, nr_down, double down dist, point, window);


//	Access rules on IOStates:

IOStateButtonFreq :: !Time !Point !WindowPtr !(IOState s) -> (!ButtonState, !IOState s);
//IOStateButtonFreq time pos cur_w (ds, es, bfs=:(dtime, down, dist, old_pos, old_w), tb)
//|	cur_w	<>	old_w	= (ButtonDown,		  (ds, es, (time, 1, dist, pos, cur_w), tb));
//|	dt		>	dTime
//||	dist`	>	dist	= (ButtonDown,		  (ds, es, (time, 1, dist, pos, cur_w), tb1));
//|	down	==	1		= (ButtonDoubleDown,  (ds, es, (time, 2, dist, pos, cur_w), tb1));
//						= (ButtonTripleDown,  (ds, es, (time, 0, dist, pos, cur_w), tb1));
//	where {
//		(dTime,tb1)	= LoadLong DoubleTime tb;	
//		dist`		= Dist x x` + Dist y y`;
//		(x`,y`)		= pos;
//		(x ,y )		= old_pos;
//		dt			= time - dtime;
//	};
IOStateButtonFreq time pos cur_w io=:{iobutton=(dtime,down,dist,old_pos,old_w),iotoolbox}
|	cur_w<>old_w			= (ButtonDown,		{io & iobutton=(time,1,dist,pos,cur_w)});
#	(dTime,tb)				= LoadLong DoubleTime iotoolbox;
|	dt>dTime || dist`>dist	= (ButtonDown,		{io & iobutton=(time,1,dist,pos,cur_w),iotoolbox=tb});
|	down==1					= (ButtonDoubleDown,{io & iobutton=(time,2,dist,pos,cur_w),iotoolbox=tb});
							= (ButtonTripleDown,{io & iobutton=(time,0,dist,pos,cur_w),iotoolbox=tb});
	where {
		dist`				= Dist x x` + Dist y y`;
		(x`,y`)				= pos;
		(x, y )				= old_pos;
		dt					= time - dtime;
	};

IOStateSetDoubleDownDist :: !DoubleDownDist !(IOState s) -> IOState s;
//IOStateSetDoubleDownDist d ioState=:(ds, es, (dtime, down, d`, pos, wPtr), tb)
//|	d == d`	= ioState;
//			= (ds, es, (dtime, down, Max 0 d, pos, wPtr), tb);
IOStateSetDoubleDownDist d io=:{iobutton=(dtime,down,d`,pos,wPtr)}
|	d == d`	= io;
			= {io & iobutton=(dtime,down,Max 0 d,pos,wPtr)};


IOStateClosed :: !(IOState s) -> (!Bool, !IOState s);
//IOStateClosed ioState=:([],_,_,_)	= (True, ioState);
//IOStateClosed ioState				= (False, ioState);
IOStateClosed io=:{iodevices=[]}	= (True,io);
IOStateClosed io					= (False,io);

IOStateHasDevice :: !(IOState s) !Device -> (!Bool, !IOState s);
//IOStateHasDevice ioState=:(ds,_,_,_) d = (DevicesHaveDevice ds d, ioState);
IOStateHasDevice io=:{iodevices} d = (DevicesHaveDevice iodevices d,io);

DevicesHaveDevice :: ![DeviceSystemState s] !Device -> Bool;
DevicesHaveDevice [dState : ds] device
|	EqualDevice (DeviceSystemStateToDevice dState) device	= True;
															= DevicesHaveDevice ds device;
DevicesHaveDevice _ _										= False;

IOStateGetAnyDevice :: !(IOState s) -> (!DeviceSystemState s, !IOState s);
//IOStateGetAnyDevice ioState=:([dState : _],_,_,_) = (dState, ioState);
//IOStateGetAnyDevice _
//	= IOStateError "IOStateGetAnyDevice" "ioState" "IOState argument is empty";
IOStateGetAnyDevice io=:{iodevices=[dState:_]} = (dState,io);
IOStateGetAnyDevice _ = IOStateError "IOStateGetAnyDevice" "ioState" "IOState argument is empty";

IOStateGetDevice :: !(IOState s) !Device -> (!DeviceSystemState s, !IOState s);
//IOStateGetDevice ([],_,_,_) _
//	= IOStateError "IOStateGetDevice" "IOState argument is empty";
//IOStateGetDevice ioState=:(ds,_,_,_) d = (DevicesGetDevice ds d, ioState);
IOStateGetDevice io=:{iodevices=[]} _	= IOStateError "IOStateGetDevice" "IOState argument is empty";
IOStateGetDevice io=:{iodevices} d		= (DevicesGetDevice iodevices d,io);

DevicesGetDevice :: ![DeviceSystemState s] !Device -> DeviceSystemState s;
DevicesGetDevice [dState : ds] d
|	EqualDevice (DeviceSystemStateToDevice dState) d	= dState;
														= DevicesGetDevice ds d;
DevicesGetDevice _ d
	=	IOStateError "IOStateGetDevice" (DeviceToString d +++ " not present in IOState");

IOStateRemoveAnyDevice :: !(IOState s) -> (!DeviceSystemState s, !IOState s);
//IOStateRemoveAnyDevice ([d : ds], es, bfs, tb) = (d, (ds, es, bfs, tb));
//IOStateRemoveAnyDevice _
//	=	IOStateError "IOStateRemoveAnyDevice" "IOState argument is empty";
IOStateRemoveAnyDevice io=:{iodevices=[d:ds]} = (d,{io & iodevices=ds});
IOStateRemoveAnyDevice _ = IOStateError "IOStateRemoveAnyDevice" "IOState argument is empty";

IOStateRemoveDevice	:: !(IOState s) !Device -> IOState s;
//IOStateRemoveDevice (ds, es, bfs, tb) d = (DevicesRemoveDevice ds d, es, bfs, tb);
IOStateRemoveDevice io=:{iodevices=ds} d = {io & iodevices=DevicesRemoveDevice ds d};

DevicesRemoveDevice	:: ![DeviceSystemState s] !Device -> [DeviceSystemState s];
DevicesRemoveDevice [dState : ds] d
|	EqualDevice (DeviceSystemStateToDevice dState) d	= ds;
	#!	ds` = DevicesRemoveDevice ds d;
	= 	[dState : ds`];
DevicesRemoveDevice ds _ = ds;

IOStateSetDevice :: !(IOState s) !(DeviceSystemState s) -> IOState s;
//IOStateSetDevice (ds, es, bfs, tb) d
//	=	let! {
//			ds`
//		} in (ds`, es, bfs, tb);
//	where {
//		ds` = DevicesSetDevice ds (Priority (DeviceSystemStateToDevice d)) d;
//	};
IOStateSetDevice io=:{iodevices=ds} d
	#!	ds` = DevicesSetDevice ds (Priority (DeviceSystemStateToDevice d)) d;
	=	{io & iodevices=ds`};

DevicesSetDevice :: ![DeviceSystemState s] !Int !(DeviceSystemState s) -> [DeviceSystemState s];
DevicesSetDevice ds=:[dState1 : dStates] p dState2
|	EqualDevice device1 (DeviceSystemStateToDevice dState2)	= [dState2 : dStates];
|	p > Priority device1 									= [dState2 : ds];
		#!	dStates1 = DevicesSetDevice dStates p dState2;
		=	[dState1 : dStates1];
	where {
		device1  = DeviceSystemStateToDevice dState1;
	};
DevicesSetDevice _ _ dState = [dState];


IOStateGetWorld :: !(IOState s) -> (!*World,!IOState s);
IOStateGetWorld io=:{ioworld=[w:ws]} = (w,{io & ioworld=ws});

IOStateSetWorld :: !*World !(IOState s) -> IOState s;
IOStateSetWorld w io=:{ioworld} = {io & ioworld=[w:ioworld]};

IOStateGetToolbox :: !(IOState s) -> (!*Toolbox, !IOState s);
//IOStateGetToolbox (ds, es, bfs, tb) = (tb, (ds, es, bfs, NewToolbox));
IOStateGetToolbox io=:{iotoolbox} = (iotoolbox,{io & iotoolbox=NewToolbox});

IOStateSetToolbox :: !*Toolbox !(IOState s) -> IOState s;
//IOStateSetToolbox tb (ds, es, bfs, _) = (ds, es, bfs, tb);
IOStateSetToolbox tb io = {io & iotoolbox=tb};

IOStateChangeToolbox :: !(*Toolbox -> *Toolbox) !(IOState s) -> IOState s;
//IOStateChangeToolbox f (ds, es, bfs, tb)
//	=	let! {
//			tb`;
//	} in (ds, es, bfs, tb`);
//	where {
//		tb` = f tb;
//	};
IOStateChangeToolbox f io=:{iotoolbox}
	#!	tb = f iotoolbox;
	=	{io & iotoolbox=tb};

IOStateAccessToolbox :: !(*Toolbox -> (!x, !*Toolbox)) !(IOState s) -> (!x, !IOState s);
//IOStateAccessToolbox f (ds, es, bfs, tb)
//= 	(x, (ds, es, bfs, tb1));
//	where {
//		(x, tb1) = f tb;
//	};
IOStateAccessToolbox f io=:{iotoolbox}
	#! (x,tb) = f iotoolbox;
	=  (x,{io & iotoolbox=tb});


//	Access-rules on DeviceSystemStates:

DeviceSystemStateToDevice :: !(DeviceSystemState s) -> Device;
DeviceSystemStateToDevice (TimerSystemState	 _) = TimerDevice;
DeviceSystemStateToDevice (MenuSystemState	 _) = MenuDevice;
DeviceSystemStateToDevice (WindowSystemState _) = WindowDevice;
DeviceSystemStateToDevice (DialogSystemState _) = DialogDevice;
DeviceSystemStateToDevice (AppleEventSystemState _) = AppleEventDevice;

//	Operations on Devices:

EqualDevice	:: !Device		!Device			-> Bool;
EqualDevice TimerDevice		TimerDevice		= True;
EqualDevice MenuDevice 		MenuDevice		= True;
EqualDevice WindowDevice	WindowDevice	= True;
EqualDevice DialogDevice	DialogDevice	= True;
EqualDevice AppleEventDevice AppleEventDevice = True;
EqualDevice _				_				= False; 

DeviceToString :: !Device		-> String;
DeviceToString TimerDevice		= "TimerDevice";
DeviceToString MenuDevice		= "MenuDevice";
DeviceToString WindowDevice		= "WindowDevice";
DeviceToString DialogDevice		= "DialogDevice";
DeviceToString AppleEventDevice = "AppleEventDevice";

Priority :: !Device -> Int;
Priority TimerDevice	= 4;
Priority MenuDevice		= 3;
Priority DialogDevice	= 2;
Priority WindowDevice	= 1;
Priority AppleEventDevice = 0;
